library(shiny)

source("MixtureUncertainty.r")

options(shiny.sanitize.errors = FALSE) # Prevents "An error has occurred. Check your logs or contact the app author for clarification."

shinyUI(fluidPage(
    textInput("lower.limit.text", "lower limits of the 95% credible intervals (separated by commas)", value = "200,220"), 
    textInput("upper.limit.text", "upper limits of the 95% credible intervals (separated by commas)", value = "900,990"), 
    textOutput("preresult"),
    textOutput("result"),
    textOutput("divider"),
    textOutput("prereferences"),
    textOutput("paper"),
    textOutput("book"),
    textOutput("divider2"),
    textOutput("precode"),
    textOutput("code"),
    textOutput("divider3"),
    textOutput("prelicense"),
    textOutput("license"),
))
