library(shiny)

# Define server logic required to draw a histogram
shinyServer(function(input, output) {
    output$preresult <- renderText({
        paste0("RESULT")
    })
    output$result <- renderText({
        paste0(AppCombinedConfidenceInterval(lower.limit.text = input$lower.limit.text, upper.limit.text = input$upper.limit.text))
    })
    output$divider <- renderText({
        paste0("☕️")
    })
    output$prereferences <- renderText({
        paste0("CITATION")
    })
    output$paper <- renderText({
        paste0('This method of uncertainty quantification was introduced in D. R. Bickel, "Propagating uncertainty about molecular evolution models and prior distributions to phylogenetic trees," DOI: 10.5281/zenodo.5810696, URL: https://doi.org/10.5281/zenodo.5810696 (2021).')
    })
    output$book <- renderText({
        paste0("Additional explanation is in D. R. Bickel, Phylogenetic Trees and Molecular Evolution: A Hands-on Introduction with Uncertainty Quantification Corrected, URL: https://davidbickel.com/evolution/ (2022).")
    })
    output$precode <- renderText({
      paste0("CODE FOR UNEQUAL WEIGHTS")
    })
    output$code <- renderText({
      paste0("Sounce code enabling the use of unequal weights is at https://davidbickel.com/evolution/ (2022).")
    })
    output$divider2 <- renderText({
        paste0("🥃")
    })
    output$divider3 <- renderText({
      paste0("🍷")
    })
    output$prelicense <- renderText({
        paste0("TERMS OF USE")
    })
    output$license <- renderText({
        paste0('This web app and the contents of its files are subject to the Mozilla Public License, Version 2.0 (the "License"); you may not use this web app or its files except in compliance with the License. You may obtain a copy of the License at https://www.mozilla.org/en-US/MPL/2.0/ (HTML). Software distributed under the License is distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for the specific language governing rights and limitations under the License.')
    })
})
