source("Commons.R")

library(shiny)
library(bda)

MixtureNormalQuantile <- function(prob, p = NULL, mean, sd)
{
  if(IsMissing(p))
  {  
    len <- length(mean)
    stopifnot(len == length(sd))
    p <- rep(1/len, len)
    MixtureNormalQuantile(prob = prob, p = p, mean = mean, sd = sd)
  }
  else if(is.numeric(p))
    qmnorm(prob = prob, p = p, mean = mean, sd = sd)
  else
    stop("bad input to MixtureNormalQuantile")
}

MixtureNormalConfidenceInterval <- function(..., mean, sd, level = DefaultConfidenceLevel(), safe = TRUE)
{
  len <- length(mean)
  stopifnot(len == length(sd))
  alpha <- 1 - level
  limit <- function(prob)
  {
    quant <- MixtureNormalQuantile(prob = prob, ..., mean = mean, sd = sd)
    if(length(quant) == 1)
    {
      if(!is.na(quant))
        quant
      else if(safe)
        stop("This software could not compute the result. If everything is entered correctly, ask David Bickel for his Mathematica function.")
      else if(prob > 1/2)
      {
        print(mean)
        print(sd)
        Inf
      }
      else if(prob < 1/2)
        -Inf
      else
        quant
    }
    else
      stop(paste0(quant, " resulted as the ", prob, " limit given a mean of ", mean, " and a standard deviation of ", sd, ".\n"))
  }
 # c(MixtureNormalQuantile(prob = alpha / 2, ..., mean = mean, sd = sd), MixtureNormalQuantile(prob = 1 - alpha / 2, ..., mean = mean, sd = sd))
  c(limit(prob = alpha / 2), limit(prob = 1 - alpha / 2))
}
CombinedConfidenceInterval <- function(..., lower.limit, upper.limit, level = DefaultConfidenceLevel()) # mixture211026
{
  if(Logical(length(lower.limit) == length(upper.limit)))
  {
    if(Logical(all(lower.limit < upper.limit)))
    {
      normal.mean <- NormalMean(lower.limit = lower.limit, upper.limit = upper.limit)
      normal.sd <- NormalStandardDeviation(lower.limit = lower.limit, upper.limit = upper.limit, level = level)
      MixtureNormalConfidenceInterval(..., mean = normal.mean, sd = normal.sd, level = level)
    }
    else
      stop("Each lower limit must be less than the corresponding upper limit. The order matters. For example, the first lower limit must be less than the first upper limit.")
  }
  else
    stop(paste0("The boxes have ", length(lower.limit), " lower limits but ", length(upper.limit), " upper limits."))
}
AppCombinedConfidenceInterval <- function(lower.limit.text, upper.limit.text, level = DefaultConfidenceLevel())
{
  sgnf <- function(x, digits = 6)
  {
    signif(x, digits)
  }
  lower.limit <- NumericVector(text = lower.limit.text)
  upper.limit <- NumericVector(text = upper.limit.text)
  ci <- CombinedConfidenceInterval(lower.limit = lower.limit, upper.limit = upper.limit, level = level)
  coverage.percent <- 100 * level
  paste0("There is an estimated ", coverage.percent, "% chance that the quantity of interest is between ", sgnf(ci[1]), " and ", sgnf(ci[2]), ". (That is the credible interval corrected for uncertainty about the model and the prior distribution, assuming each posterior distribution is approximately normal and that their models have the same posterior probability.)")
}
