Logical <- function(boo = NULL)
{
  if(!is.na(boo) && is.logical(boo))
    return(boo)
  else
    stop("Please make sure everything is entered correctly.")
}
IsMissing <- function(argument = NULL)
{ 
  is.null(argument) # length(argument) == 1 && is.NULL(argument)
}

NormalMean <- function(lower.limit, upper.limit)
{
  len <- length(lower.limit)
  stopifnot(len == length(upper.limit))
  (lower.limit + upper.limit) / 2
}
NormalStandardDeviation <- function(lower.limit, upper.limit, level = DefaultConfidenceLevel())
{
  stopifnot(length(level) == 1)
  len <- length(lower.limit)
  stopifnot(len == length(upper.limit))
  mu <- NormalMean(lower.limit = lower.limit, upper.limit = upper.limit)
  stopifnot(len == length(mu))
  prob <- (1 - level) / 2
  nsigmas <- -qnorm(p = prob)
  dev <- mu - lower.limit
  stopifnot(len == length(dev))
  stopifnot(all(dev > 0))
  dev / nsigmas
}
DefaultConfidenceLevel <- function(){0.95}

NumericVector <- function(text, sep = ",", ...)
{
  error.text <- "Each box needs either a limit or a list of limits with a comma between each limit."
  tab <- try(read.table(text = text, sep = sep, ...), silent = TRUE)
  vec <- try(as.numeric(tab), silent = TRUE)
  if(Logical(length(vec) >= 1 && !any(is.na(vec))))
    vec
  else
    stop(error.text)
}
